<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>WebRTC SIP Softphone</title>
    <script src="jssip.min.js"></script>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        button { margin: 5px; padding: 10px; }
        #debugLog { margin-top: 20px; border: 1px solid #ccc; padding: 10px; height: 200px; overflow-y: auto; }
    </style>
</head>
<body>
    <h1>WebRTC SIP Softphone</h1>
    <button id="registerBtn">Register</button>
    <button id="callBtn">Call</button>
    <button id="hangupBtn">Hangup</button>
    <button id="listenBtn">Listen</button>
    <div id="debugLog"></div>

    <script>
        let ua;
        let session;
        let listenSession;
        const debugLog = document.getElementById('debugLog');

        function log(message) {
            console.log(message);
            debugLog.innerHTML += message + '<br>';
            debugLog.scrollTop = debugLog.scrollHeight;
        }

        // Register SIP Softphone
        document.getElementById('registerBtn').addEventListener('click', function() {
            log('Attempting to register...');

            const socket = new JsSIP.WebSocketInterface('wss://instablock.instacall.digital:8089/ws');
            const configuration = {
                sockets: [socket],
                uri: 'sip:instacall@instablock.instacall.digital',
                password: '1234',
                realm: 'instablock.instacall.digital',
                authorization_user: 'instacall'
            };

            ua = new JsSIP.UA(configuration);

            ua.on('connecting', () => log('🔄 Connecting to WebSocket...'));
            ua.on('connected', () => log('🟢 Connected to WebSocket'));
            ua.on('disconnected', () => log('🔴 Disconnected from WebSocket'));
            ua.on('registered', () => log('✅ Registered successfully'));
            ua.on('unregistered', () => log('❗ Unregistered'));
            ua.on('registrationFailed', (e) => log(`❌ Registration failed: ${e.cause}`));

            ua.start();
        });

        // Dial Any Number
        document.getElementById('callBtn').addEventListener('click', function() {
            if (!ua) {
                log('❌ Please register first!');
                return;
            }

            let numberToCall = prompt("Enter number to call:");
            if (!numberToCall || !/^\d+$/.test(numberToCall)) {
                log("❌ Invalid number entered!");
                return;
            }

            let sipTarget = `sip:${numberToCall}@38.65.82.198:5060;transport=udp`;

            log(`📞 Calling ${sipTarget}...`);
            try {
                session = ua.call(sipTarget, {
                    mediaConstraints: { audio: true, video: false },
                    pcConfig: {
                        iceServers: [{ urls: ['stun:stun.l.google.com:19302'] }]
                    },
                    extraHeaders: [
                        'P-Asserted-Identity: <sip:12077691722@instablock.instacall.digital>',
                        'From: <sip:12077691722@instablock.instacall.digital>'
                    ]
                });

                session.on('connecting', () => log('⏳ Call connecting...'));
                session.on('progress', () => log('🔊 Call is ringing...'));
                session.on('accepted', () => log('✅ Call accepted!'));
                session.on('confirmed', () => log('👍 Call confirmed'));
                session.on('ended', () => log('📞 Call ended'));
                session.on('failed', (e) => log(`❌ Call failed: ${e.cause}`));
            } catch (error) {
                log(`❌ Error making call: ${error.message}`);
            }
        });

        // Hangup Call
        document.getElementById('hangupBtn').addEventListener('click', function() {
            if (session) {
                log('Hanging up...');
                session.terminate();
            } else {
                log('No active call to hang up.');
            }
        });

        // Listen to Active Calls (via ChanSpy)
        document.getElementById('listenBtn').addEventListener('click', function() {
            let channel = prompt("Enter the channel to listen to:");
            if (!channel) {
                log("❌ Channel is required!");
                return;
            }

            log(`Listening to channel: ${channel}`);
            window.open(`listen.php?channel=${channel}`, '_blank');
        });
    </script>
</body>
</html>
